(*--------------------------------------------------------------------**
**	    	Fa. MAMAvision Software Consult                             **
**		    Wollmatingerstrae 70b  D-78467 Konstanz	                  **
**	      Tel.: (07531)690014     Fax: (07531)690015                  **
**--Projekt-----------------------------------------------------------**
**		                  HPGL-Viewer/Printer                           **
**                     SOFTWARE\HPGL\PAS\....                         **
**--Revisionhistory---------------------------------------------------**
**
lgb
    Tslider renamed to TTrackbar in Unit ComCtrls for 32compatibility
lge
**
**--Module------------------------------------------------------------**
**  Modul-Name      : modname: comctrls.pas
**  Modul-Revision  : version: 1.0
**  Projekt-Revision: 1.0
**--------------------------------------------------------------------**
nokeywords
**--------------------------------------------------------------------*)
unit Comctrls;
(*--------------------------------------------------------------------*)
(*		          													                            *)
(*	 This component has classname and some of the properties of the   *)
(*	 Delphi2.0 component TTrackbar in Comctrls.pas       						  *)
(*		          													                            *)
(*--------------------------------------------------------------------*)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TTrackBarOrientation = (trHorizontal, trVertical);
  TTickMark = (tmBottomRight, tmTopLeft, tmBoth);      {not used}
  TTickStyle = (tsNone, tsAuto, tsManual);             {not used}

  TTrackbar = class(TCustomControl)
  private
    Thumb : TRect;
    MemDC : HDC;
    Bitmap : HBitmap;

    capture : boolean;
    capturePoint : TPoint;
    captureValue : Integer;

    fTrackWidth : Integer;
    fTrackColor : TColor;
    fOrientation : TTrackbarOrientation;
    fThumbHeight : Integer;
    fThumbColor : TColor;
    fMin : Integer;
    fMax : Integer;
    fValue : Integer;
    fOnChange : TNotifyEvent;
    fCtl3D : boolean;
    fpCtl3D : boolean;
    fTickMarks:TTickMark;
    fTickStyle:TTickStyle;
    dummy:integer;
    procedure SetTrackWidth (value : Integer);
    procedure SetTrackColor (value : TColor);
    procedure SetOrientation (value : TTrackbarOrientation);
    procedure SetThumbHeight (value : Integer);
    procedure SetThumbColor (value : TColor);
    procedure SetMin (v : Integer);
    procedure SetMax (v : Integer);
    procedure SetValue (value : Integer);
    procedure SetCtl3D (value : boolean);
  protected
    procedure Paint; override;
    procedure MouseDown (Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp (Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove (Shift: TShiftState; X, Y: Integer); override;
    procedure DrawThumb; virtual;
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
    property TrackWidth : Integer read fTrackWidth write SetTrackWidth;
    property TrackColor : TColor read fTrackColor write SetTrackColor;
    property ThumbHeight : Integer read fThumbHeight write SetThumbHeight;
    property ThumbColor : TColor read fThumbColor write SetThumbColor;
  published
    property Orientation : TTrackbarOrientation read fOrientation write SetOrientation;
    property Min : Integer read fMin write SetMin;
    property Max : Integer read fMax write SetMax;
    property Position : Integer read fValue write SetValue;
    property Ctl3D : boolean read fCtl3D write SetCtl3D;
    property OnChange : TNotifyEvent read FOnChange write FOnChange;

    property Pagesize:integer read dummy write dummy;
    property Frequency:integer read dummy write dummy;
    property Selstart:integer read dummy write dummy;
    property Selend:integer read dummy write dummy;
    property Taborder:integer read dummy write dummy;
    property TickMarks:TTickMark read fTickMarks write fTickMarks;
    property TickStyle:TTickStyle read fTickStyle write fTickStyle;
    property ParentCtl3D : boolean read fpCtl3D write fpCtl3D;

    property Color;
    property Enabled;
    property HelpContext;
    property Hint;
    property ParentShowHint;
    property ShowHint;
    property Tag;
    property Visible;

    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;

  end;

procedure Register;

implementation

constructor TTrackbar.Create (AOwner : TComponent);
begin
  inherited Create (AOwner);
  Width := 50;
  Height := 200;
  fTrackWidth := 10;
  fOrientation := trVertical;
  fTrackColor := clBtnFace;
  fThumbColor := clBtnFace;
  fMin := 0;
  fMax := 100;
  fValue := 0;
  fThumbHeight := 20;
  fOnChange := Nil;
  fCtl3D := True;
  capture := False;
  thumb.left := -1;
end;

destructor TTrackbar.Destroy;
begin
  if Bitmap <> 0 then DeleteObject (Bitmap);
  if MemDC <> 0 then DeleteDC (MemDC);
  inherited Destroy
end;

procedure TTrackbar.SetTrackWidth (value : Integer);
begin
  if fTrackWidth <> value then
  begin
    fTrackWidth := value;
    Invalidate
  end
end;

procedure TTrackbar.SetOrientation (value : TTrackbarOrientation);
begin
  if value <> fOrientation then
  begin
    fOrientation := value;
    Invalidate
  end
end;

procedure TTrackbar.SetTrackColor (value : TColor);
begin
  if value <> fTrackColor then
  begin
    fTrackColor := value;
    Invalidate
  end
end;

procedure TTrackbar.SetThumbHeight (value : Integer);
begin
  if value <> fThumbHeight then
  begin
    fThumbHeight := value;
    Invalidate
  end
end;

procedure TTrackbar.SetThumbColor (value : TColor);
begin
  if value <> fThumbColor then
  begin
    fThumbColor := value;
    Invalidate
  end
end;

procedure TTrackbar.SetMin (v : Integer);
begin
  if v <> fMin then
  begin
    fMin := V;
    if Position < fMin then Position := fMin;
    Invalidate
  end
end;

procedure TTrackbar.SetMax (v : Integer);
begin
  if v <> fMax then
  begin
    fMax := V;
    if Position > fMax then Position := fMax;
    Invalidate
  end
end;

procedure TTrackbar.SetValue (value : Integer);
begin
  if value < Min then
    value := Min
  else if value > Max then
    value := Max;
  if value <> fValue then
  begin
    fValue := Value;
    if Assigned (fOnChange) then OnChange (self);
    DrawThumb;
  end;
end;

procedure TTrackbar.SetCtl3D (value : boolean);
begin
  if value <> fCtl3D then
  begin
    fCtl3D := value;
    Invalidate
  end
end;


procedure TTrackbar.Paint;
var Rect : TRect;
begin
  with Canvas do
  begin
    if MemDC = 0 then MemDC := CreateCompatibleDC (Canvas.Handle);

    if fOrientation = trVertical then
    begin
      if Bitmap = 0 then Bitmap := CreateCompatibleBitmap (Canvas.Handle, Width, ThumbHeight);
      Rect.top := 0;
      Rect.bottom := Height;
      Rect.left := (Width - TrackWidth) div 2;
      Rect.Right := Rect.Left + TrackWidth
    end
    else
    begin
      if Bitmap = 0 then Bitmap := CreateCompatibleBitmap (Canvas.Handle, ThumbHeight, Height);
      Rect.top := (Height - TrackWidth) div 2;
      Rect.bottom := Rect.Top + TrackWidth;
      Rect.left := 0;
      Rect.Right := Width
    end;

    Brush.Color := TrackColor;
    if Ctl3D then
    begin
      Pen.Color := clBtnHighlight;
      with Rect do
      begin
        Rectangle (left, top, right, bottom);
        Pen.Color := clBtnShadow;
        MoveTo (left, top);
        LineTo (right, top);
        MoveTo (left, top);
        LineTo (left, bottom)
      end
    end
    else FillRect (Rect);
    DrawThumb;

  end
end;

procedure TTrackbar.DrawThumb;
var
  basePos : Integer;
  rc : bool;
  oldBmp : HBitmap;
  oldThumb : TRect;
begin
  if csLoading in ComponentState then Exit;
  oldBmp := SelectObject (MemDC, Bitmap);

  if Enabled then Canvas.Brush.Color := ThumbColor else Canvas.Brush.Color := clGray;
  if Ctl3D then Canvas.Pen.Color := clBtnHighlight else Canvas.Pen.Color := clBlack;
  oldThumb := Thumb;

  if Orientation = trVertical then
  begin
    basePos := (Height - ThumbHeight) * (Position - Min) div (Max - Min);
    Thumb.left := 0;
    Thumb.right := Width;
    Thumb.Bottom := Height - BasePos;
    Thumb.top := Thumb.Bottom - ThumbHeight;
    if oldThumb.left <> -1 then with oldThumb do
      BitBlt (Canvas.Handle, Left, Top, Width, ThumbHeight, MemDC, 0, 0, SRCCOPY);

    with Thumb do
      rc := BitBlt (MemDC, 0, 0, Width, ThumbHeight, Canvas.Handle, Left, Top, SRCCOPY);
  end
  else
  begin
    basePos := (Width - ThumbHeight) * (Position - Min) div (Max - Min);
    Thumb.left := basePos;
    Thumb.Right := Thumb.left + ThumbHeight;
    Thumb.Top := 0;
    Thumb.Bottom := Height;
    if oldThumb.left <> -1 then with oldThumb do
      BitBlt (Canvas.Handle, Left, Top, ThumbHeight, Height, MemDC, 0, 0, SRCCOPY);

    with Thumb do
      rc := BitBlt (MemDC, 0, 0, ThumbHeight, Height, Canvas.Handle, Left, Top, SRCCOPY);
  end;

  with Canvas do
  begin
    with Thumb do if Ctl3D then
    begin
      Rectangle (left, top, right-1, bottom-1);
      Pen.Color := clBtnShadow;
      MoveTo (Left + 1, Bottom - 3);
      LineTo (Left + 1, Top+1);
      LineTo (Right - 2, Top+1);
      MoveTo (Left, Bottom - 1);
      LineTo (Right-1, Bottom - 1);
      LineTo (Right-1, Top - 1)
    end
    else
      Rectangle (left, top, right, bottom);
  end;

  SelectObject (MemDC, OldBmp);
end;

procedure TTrackbar.MouseDown (Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseDown (Button, Shift, X, Y);
  if (Button = mbLeft) and PtInRect (Thumb, Point (X, Y)) then
  begin
    capture := True;
    capturePoint := Point (X, Y);
    captureValue := Position;
  end;
end;

procedure TTrackbar.MouseUp (Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseUp (Button, Shift, X, Y);
  if (Button = mbLeft) then capture := False
end;

procedure TTrackbar.MouseMove (Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseMove (shift, X, Y);
  if capture then
    if Orientation = trVertical then
      Position := captureValue + Min + (Max - Min) * (capturePoint.Y - Y) div (Height - ThumbHeight)
    else
      Position := captureValue + Min + (Max - Min) * (X - capturePoint.X) div (Width - ThumbHeight);
end;

procedure Register;
begin
  RegisterComponents('Beispiele', [TTrackbar]);
end;

end.
